// Code generated from shared/sources.json. DO NOT EDIT.
// Run build to regenerate.

const ALLOWED_SOURCES = new Set([
  "404media.co",
  "9to5google.com",
  "9to5mac.com",
  "abc.net.au",
  "abcnews.go.com",
  "ajc.com",
  "aljazeera.com",
  "anandtech.com",
  "androidcentral.com",
  "androidpolice.com",
  "apnews.com",
  "arstechnica.com",
  "arstechnica.com",
  "avclub.com",
  "axios.com",
  "azcentral.com",
  "babylonbee.com",
  "baltimoresun.com",
  "barrons.com",
  "bbc.co.uk",
  "bbc.com",
  "billboard.com",
  "bleacherreport.com",
  "bloomberg.com",
  "bostonglobe.com",
  "businessinsider.com",
  "buzzfeednews.com",
  "cbc.ca",
  "cbsnews.com",
  "cbssports.com",
  "chicagotribune.com",
  "chron.com",
  "clickhole.com",
  "cnbc.com",
  "cnet.com",
  "cnn.com",
  "collider.com",
  "courier-journal.com",
  "dailybeast.com",
  "dailymail.co.uk",
  "dallasnews.com",
  "deadline.com",
  "deadspin.com",
  "denverpost.com",
  "discovermagazine.com",
  "dispatch.com",
  "dw.com",
  "economist.com",
  "engadget.com",
  "entrepreneur.com",
  "eonline.com",
  "espn.com",
  "etonline.com",
  "ew.com",
  "fastcompany.com",
  "fool.com",
  "forbes.com",
  "fortune.com",
  "foxnews.com",
  "foxsports.com",
  "france24.com",
  "freep.com",
  "ft.com",
  "gamespot.com",
  "gizmodo.com",
  "globalnews.ca",
  "haaretz.com",
  "hackernoon.com",
  "hard-drive.net",
  "hbr.org",
  "hindustantimes.com",
  "hollywoodreporter.com",
  "howtogeek.com",
  "huffpost.com",
  "ign.com",
  "inc.com",
  "independent.co.uk",
  "indiewire.com",
  "indystar.com",
  "infoworld.com",
  "inquirer.com",
  "investopedia.com",
  "irishtimes.com",
  "japantimes.co.jp",
  "jsonline.com",
  "kansascity.com",
  "kotaku.com",
  "latimes.com",
  "lifehacker.com",
  "livescience.com",
  "macrumors.com",
  "marketwatch.com",
  "mercurynews.com",
  "miamiherald.com",
  "mirror.co.uk",
  "mlb.com",
  "motherjones.com",
  "nationalgeographic.com",
  "nationalreview.com",
  "nature.com",
  "nba.com",
  "nbcnews.com",
  "nbcsports.com",
  "ndtv.com",
  "newscientist.com",
  "newsweek.com",
  "nfl.com",
  "nhl.com",
  "nme.com",
  "npr.org",
  "nypost.com",
  "nytimes.com",
  "nzherald.co.nz",
  "oregonlive.com",
  "people.com",
  "philly.com",
  "phys.org",
  "pitchfork.com",
  "pointandclickbait.com",
  "politico.com",
  "polygon.com",
  "popsci.com",
  "post-gazette.com",
  "propublica.org",
  "quantamagazine.org",
  "qz.com",
  "reason.com",
  "reductress.com",
  "reuters.com",
  "reviewjournal.com",
  "rollingstone.com",
  "rottentomatoes.com",
  "rte.ie",
  "sacbee.com",
  "sandiegouniontribune.com",
  "sbnation.com",
  "sciencedaily.com",
  "sciencemag.org",
  "scientificamerican.com",
  "scmp.com",
  "screenrant.com",
  "seattletimes.com",
  "seekingalpha.com",
  "semafor.com",
  "sfchronicle.com",
  "sfgate.com",
  "si.com",
  "slashfilm.com",
  "slate.com",
  "sltrib.com",
  "smh.com.au",
  "smithsonianmag.com",
  "space.com",
  "sports.yahoo.com",
  "startribune.com",
  "statnews.com",
  "straitstimes.com",
  "tampabay.com",
  "techcrunch.com",
  "techdirt.com",
  "telegraph.co.uk",
  "tennessean.com",
  "theage.com.au",
  "theathletic.com",
  "theatlantic.com",
  "thedailybeast.com",
  "theglobeandmail.com",
  "theguardian.com",
  "thehill.com",
  "theintercept.com",
  "thelocal.com",
  "thenextweb.com",
  "theonion.com",
  "theregister.com",
  "thestar.com",
  "thestreet.com",
  "thesun.co.uk",
  "theverge.com",
  "time.com",
  "timesofindia.indiatimes.com",
  "timesofisrael.com",
  "tmz.com",
  "tomshardware.com",
  "torrentfreak.com",
  "twincities.com",
  "usatoday.com",
  "usmagazine.com",
  "variety.com",
  "venturebeat.com",
  "vox.com",
  "vulture.com",
  "washingtonpost.com",
  "windowscentral.com",
  "wired.com",
  "wsj.com",
  "xda-developers.com",
  "zdnet.com",
]);

const WILDCARD_PATTERNS = [
  "*.substack.com",
  "*.medium.com",
];

function isAllowedSource(url) {
  try {
    const host = new URL(url).hostname.toLowerCase().replace(/^www\./, '');
    
    // Check exact match
    if (ALLOWED_SOURCES.has(host)) return true;
    
    // Check subdomain of allowed source
    for (const domain of ALLOWED_SOURCES) {
      if (host.endsWith('.' + domain)) return true;
    }
    
    // Check wildcard patterns
    for (const pattern of WILDCARD_PATTERNS) {
      const suffix = pattern.replace(/^\*/, '');
      if (host.endsWith(suffix) || host === suffix.replace(/^\./, '')) return true;
    }
    
    return false;
  } catch {
    return false;
  }
}
